#!/usr/bin/env python

import sys
import os
import mycgi
# change next line to 1 to debug
debug=0

if debug:
  import sys
  sys.stderr=sys.stdout
  print("Content-type: text/plain\n")


class Webinput:
  ''' Handles different approaches human usable Python 3 modules
  have concerning web request post and get methods. Current
  class just deals with single string values. Post coming from
  stdin, and get coming from the url query string. To be extended
  to handle file inputs e.g. using multipart which I haven't
  got my head around yet. '''

  def __init__(self,fh=sys.stdin):
    self.environ=os.environ
    self.stdin=fh.read()
    self._get_mycgi_form()
    self.keyl=list(self.form.keys())

  def _get_mycgi_form(self):
    ''' first check for form input '''
    self.formtype='none'
    self.form={}
    if self.stdin == "":
      # null input trying get approach
      try:
        self.formtype='get'
        self.getform = mycgi.Form()
        keys=list(self.getform.keys())
        for key in keys:
          value=self.getform.getfirst(key)
          self.form[key]=value
      except:
        pass
    else:
      # seem to have post input
      if debug:
          print('\n\nWebinput environ: '+str(self.environ)+'\n\n')
          print('\n\nstdin stream: '+str(self.stdin)+'\n\n')
      import urllib.parse
      keys_values=self.stdin.split('&')
      if len(keys_values) == 0:
        return
      else:
        self.formtype='post'
        for kv in keys_values:
          if '=' in kv:
            k,v=kv.split('=',maxsplit=1)
            k_sent=urllib.parse.unquote(k)
            v_sent=urllib.parse.unquote_plus(v)
            self.form[k_sent]=v_sent
    return

  def keys(self):
      return self.keyl

  def has_key(self,search):
    return search in self.keys()

  def firstval(self,key,default=""):
    """ returns value from form as a single string, or default for 
    empty/wrong type. Returns first of a multi-valued submission. """
    if not key in self.keys():
      return default
    if self.formtype in ['get','post']:
      value=self.form[key]
    else:
      return default
    if type(value) == type([]): # multi value submission
      if value == []: # empty list ??
        return default 
      elif type(value[0]) == type(""): # first element is string
        return value[0]
      else: # list, but 1st element not a string ?
        return default 
    elif type(value) == type(""):
      return value # normal case
    else: # dont know what type of data this is ?
      return default 

  def has_required(self,keylist):
    ''' true if keys has all keys in keylist '''
    for key in keylist:
        if not key in self.keyl:
            return False
    return True

def tester():
    ''' currently only figured how to test this using post 
    and not get method. '''
    from io import StringIO
    ifh = StringIO('a=b&address=thing@example.com&number=42')
    wip=Webinput(ifh) # post simulation
    print('keys: '+str(wip.keys()))
    print('should pass')
    for key in wip.keys():
      print('has_key: '+str(key)+' '+str(wip.has_key(key)))
      print('firstval: '+str(key)+' '+str(wip.firstval(key)))
    print('should fail')
    print('has no key: '+str(wip.has_key('notakey')))
    required=['number','address','a']
    print('should pass')
    print(str(required)+ ' has_required '+str(wip.has_required(required)))
    print('should fail')
    notallthere=['number','address','a','notakey']
    print(str(notallthere)+ ' has_required '+str(wip.has_required(notallthere)))

if __name__ == '__main__':
    tester()
else:
    pass
    # print('imported code')
