from email_validator import validate_email, EmailNotValidError


def is_email(email,check_deliv=False):
  try:
    # Check that the email address is valid. Turn on check_deliverability
    # for first-time validations like on account creation pages (but not
    # login pages).
    emailinfo = validate_email(email, check_deliverability=check_deliv)
    # After this point, use only the normalized form of the email address,
    # especially before going to a database query.
    email = emailinfo
    return True
  except EmailNotValidError as e:
    # The exception message is human-readable explanation of why it's
    # not a valid (or deliverable) email address.
    # print(str(e)) for error message giving reason
    return False

def normalise_email(email,check_deliv=False):
  # calling is_email before this one will avoid the
  # exception if reason for rejection isn't wanted
  try:
    # Check that the email address is valid. Turn on check_deliverability
    # for first-time validations like on account creation pages (but not
    # login pages).
    emailinfo = validate_email(email, check_deliverability=check_deliv)
    # After this point, use only the normalized form of the email address,
    # especially before going to a database query.
    email = emailinfo # this is an object. Introspect it if need more info
    return email.email.lower() 
  except EmailNotValidError as e:
    # The exception message is human-readable explanation of why it's
    # not a valid (or deliverable) email address.
    return(str(e))

def tests():
  emails = ["my+address@example.org",
            "not","a@this..that",
            "me@Ｄｏｍａｉｎ.com",
            "John_O'Reilly@gmail.com",
            "SoMeOne@OBe.KanoBe.Bog"]
  for email in emails:
      if is_email(email):
          print(email+' is valid')
          normalised=normalise_email(email)
          print('normalised email: '+normalised)
          ndcheck=normalise_email(email,check_deliv=True)
          if ndcheck != normalised:
            print('checking deliverability: '+ndcheck)
      else:
          error=normalise_email(email)
          print(email+' is not valid')
          print('reason not valid: '+normalise_email(email))

if __name__ == '__main__':
    tests()
