#!/usr/bin/env python

# change next line to 1 to debug script
debug=0

""" unsub.cgi This file is the unsubscribe page for an email list
    Richard Kay last changed: 29 Nov 2023
"""

if debug:
  import sys
  sys.stderr=sys.stdout
  print("Content-type: text/plain\n")

import cgiutils
import webinput
woi=webinput.Webinput()
import tablcgi
from table_details import laddr
data_parent=cgiutils.data_directory
cfg_parent=cgiutils.cfg_directory

if debug:
    print('''<pre>/n/n 
    woi keys: '''+str(list(woi.keys()))+ '''\n\n
    woi.stdin: '''+str(woi.stdin)+'''\n\n
    woi.environ: '''+str(woi.environ)+'''\n\n
    </pre> ''')

def send_confirmation(email,listname,v):
  domain=v['domain']
  fromad='no-reply@'+domain
  message="From: "+fromad+"\n"
  to_line="To: %s\n" % email
  message+=to_line
  message+="Subject: "+listname+" unsubscription complete \n\n"
  message+="You have unsubscribed from "+listname+" .\n"
  message+="\n"
  message+="You will not receive further messages from this list.\n"
  message+="In case of errors, the contact for "+listname+" is "+ v['Listowner']+" .\n"
  message+="\n"
  cgiutils.send_mail(fromad,email,message)

def do_inserts(s,Vars):
  ''' less exception/bug prone %s format insertions in string '''
  for var in Vars:
      if '%s' in s and type(var) == type('string'):
          parts=s.split('%s',maxsplit=1)
          s=parts[0]+var+parts[1]
  return s

def send_code_by_email(email,listname,code,v):
  url=v['List-Unsubscribe']
  Vars=[url,email,listname,code]
  unsub_link="Or use this link: %s?membemail=%s&listname=%s&code=%s&unsub=unsub \n\n"
  unsub_link=do_inserts(unsub_link,Vars)
  domain=v['domain']
  fromad='no-reply@'+domain
  message="From: "+fromad+"\n"
  to_line="To: %s\n" % email
  message+=to_line
  message+="Subject: "+listname+" confirmation code \n\n"
  message+="Someone, presumably you, asked to leave "+listname+" .\n"
  message+="You may either complete the form by entering code: "+str(code)+"\n"
  message+="\n"
  message+=unsub_link
  message+="In case of errors, the contact for "+listname+" is "+ v['Listowner']+" .\n"
  message+="\n"
  cgiutils.send_mail(fromad,email,message)

def main():
  #cgiutils.html_header(title="Nextlist Mail Management System")
  session=False 
  listname=woi.firstval("listname")
  email=woi.firstval("membemail")
  formcode=woi.firstval("code")
  if len(list(woi.keys())) == 0 :
    # if no keys send the form to the browser
    cgiutils.html_header(title="Nextlist Mail Management System")
    print(cgiutils.send_form("unsub.form",vars=[listname,email,'']))
    cgiutils.html_end(session,want_form=1)
    return
  elif not woi.has_required(["listname"]):
    cgiutils.html_header(title="Nextlist Mail Management System")
    cgiutils.html_end(session,
       error="You havn't input a listname.")
    return
  # need to check listname valid and exists. If it 
  # does, dl/listname folder must also exist
  if listname == '' or not cgiutils.is_valid(listname,allowed='^[a-z][a-z_]*$'):
    cgiutils.html_header(title="Nextlist Mail Management System")
    cgiutils.html_end(session,error="Missing or invalid listname.")
    return 
  # check list folder exists
  import os.path
  dl=os.path.join(data_parent,listname)
  cfgl=os.path.join(cfg_parent,listname,'list.cfg') # list config file
  if not os.path.exists(cfgl) :
    cgiutils.html_header(title="Nextlist Mail Management System")
    cgiutils.html_end(session,error="Listname not existent or not installed.")
    return
  # we can now get the list variables and confirm admin email and PIN.
  # has listname - process email
  v=cgiutils.get_vars(cfgl) # extract list config as directory
  if email == '' or not cgiutils.is_email(email,deliv_check=True):
    cgiutils.html_header(title="Nextlist Mail Management System")
    cgiutils.html_end(session,error="Missing or invalid email.")
    return
  email=cgiutils.normalise_email(email)
  # OK we have an email and list name. Is the email a member ?
  option="none" 
  for word in ["unsub","send"]:
    if word in woi.keys():
      option=word
  if option=="none": 
    cgiutils.html_header(title="Nextlist Mail Management System")
    cgiutils.html_end(session,error="Invalid submit button value.")
    return
  # OK we have an email and list name
  addrtab=tablcgi.table(laddr,dir=dl)
  if option in ["unsub","send"]:
    if email not in addrtab.keys():
      cgiutils.html_header(title="Nextlist Mail Management System")
      cgiutils.html_end(session,error="Not a list member. Can't unsubscribe.")
      return
  else:
    cgiutils.html_header(title="Nextlist Mail Management System")
    cgiutils.html_end(session,error="Invalid form option.")
    return
  # have unsub or send option check code 
  index=addrtab.find(email)
  validcode=addrtab.data[index]['code']
  if option == "unsub": # code validation required 
    if not woi.has_required(["code"]):
      cgiutils.html_header(title="Nextlist Mail Management System")
      cgiutils.html_end(session,
         error="You havn't provided an unsubscribe code.")
      return
    if formcode == '' or not cgiutils.is_valid(formcode,allowed='^[0-9]*$'):
      cgiutils.html_header(title="Nextlist Mail Management System")
      cgiutils.html_end(session,error="Missing or invalid unsubscribe code.")
      return 
    if int(formcode) != int(validcode): # wrong unsub code input
      cgiutils.html_header(title="Nextlist Mail Management System")
      cgiutils.html_end(session,error="Incorrect unsubscribe code.")
      return
    # OK, we have a valid unsub request. Process it.
      # valid unsub request
    addrtab.delrow(email)
    addrtab.save()
    cgiutils.html_header(title="Nextlist Mail Management System")
    send_confirmation(email,listname,v)
    print("<p> Unsubscription successful </p>")
    cgiutils.html_end(session,received=1)
    return 
  elif option == "send": # email confirmation required
    cgiutils.html_header(title="Nextlist Mail Management System")
    send_code_by_email(email,listname,validcode,v)
    url=v['List-Unsubscribe']
    print("<p> Unsubscription confirmation code sent to your email.</p>")
    print("<p> The email with this code contains a one click ")
    print("confirmation, or you may input your listname, ")
    print('address and this code to the webform <a href="'+url+'">'+url+'</a> to confirm.</p>')
    cgiutils.html_end(session,received=1)
  else:
    # should have trapped this one earlier ???
    cgiutils.html_header(title="Nextlist Mail Management System")
    cgiutils.html_end(session,error="Invalid option value (2nd trap).")
  return 

if __name__ == "__main__":
  try: 
    main()
  except:
    import traceback
    print("error detected in unsub.cgi main()")
    traceback.print_exc()

