#!/usr/bin/env python
#
#  table_details.py: details of tables used within LETS CGI 
# simple accounts management system. These details are coded 
# in this file and imported into programs which access
# tables, enabling table metadata and definitions, together
# with table/column specific presentation code to be edited in one place.

# trivial table definitions class used to simplify naming
class table_def:
  pass

# code for printing human readable date/time from internal format 
def print_date_time(timeval):
  ''' function used for ack tables date output '''
  import time
  time_struct=time.localtime(timeval)
  return str(time.asctime(time_struct))+'\n'

def print_url(url):
  ''' function used for url output '''
  import cgiutils
  if url == 'None':
    return ''
  elif cgiutils.is_url(url):
    return '<a href="'+url+'">link</a>\n'
  else:
    return ''

def show_picture(picfile):
  if picfile == 'None':
    return ''
  else:
    return '<img src="'+picfile+'" width=100 height=120 alt="" />\n' 

# code for printing human readable date/time from internal format 

def print_date_time(timeval):
  ''' function used for ack tables date output '''
  import time
  time_struct=time.localtime(timeval)
  return str(time.asctime(time_struct))+'\n'

def print_date(timeval):
  ''' function used for wantoffer tables date output '''
  import time
  time_struct=time.localtime(timeval)
  # output time in DD Mmm YYYY format e.g 12 Jan 2007
  return str(time.strftime("%d %b %Y",time_struct))+'\n'


def print_skill(level):
  ''' code for printing skill level '''
  if level == 'P':
    return "Professional\n"
  elif level == 'S':
    return "Semi skilled\n"
  elif level == 'B':
    return "Beginner\n"
  else: 
    return "N/A\n"

def digest_cookie(cookie):
  ''' code for displaying last part of a md5 digested cookie, so 
      the real cookie is not visible '''
  import md5
  ho=md5.md5(cookie)
  return ho.hexdigest()[-16:] # prints last 16 hex digits 

# globals to help speed comparison functions
import re
cre_int=re.compile('^[0-9]+$')

def cmp(x, y):
    """
    Replacement for built-in function cmp that was removed in Python 3
    Compare the two objects x and y and return an integer according to
    the outcome. The return value is negative if x < y, zero if x == y
    and strictly positive if x > y.
    """
    return (x > y) - (x < y)

def cmp_acid(row1,row2):
  ''' comparison function to enable pretty sorting tables keyed on 
      ac_id field. This can be of the form "admin" (string) or "123"
      (integer value stored as a string). Int comparison is used
      if the ac_id's are both integers stored as strings.'''
  ac1=row1["ac_id"] 
  ac2=row2["ac_id"] 
  imo1=cre_int.match(ac1)
  imo2=cre_int.match(ac2)
  if imo1 and imo2:
    return cmp(int(ac1),int(ac2))
  else: 
    return cmp(ac1,ac2)

def cmp_categories(row1,row2):
  ''' comparison function to enable integer sorting of category sort 
      field stored as decimal string '''
  return cmp(int(row1["sort"]),int(row2["sort"])) 

# list addresses table 
laddr=table_def()
laddr.meta={
  "keys":["email","name","moderated","code"],
  "colheads":["Address","Name","Moderated","Code"],
  "formats":["%s","%s","%s","%s"]}
laddr.file="addresses.pkl"
laddr.index_col="email"

# pending subscriptions table 
pendsub=table_def()
pendsub.meta={
  "keys":["email","name","code","timestamp"],
  "colheads":["Address","Name","Code","TimeStamp"],
  "formats":["%s","%s","%s",print_date_time]}
pendsub.file="pendingsubs.pkl"
pendsub.index_col="email"

