#!/usr/bin/env python

# change next line to 1 to debug script
debug=0

""" sub.cgi This file handles the subscribe form for an email list
    Richard Kay last changed: 20 Dec 2023
"""

if debug:
  import sys
  sys.stderr=sys.stdout
  print("Content-type: text/plain\n")

import cgiutils
import webinput
woi=webinput.Webinput()
import tablcgi
from table_details import laddr, pendsub
data_parent=cgiutils.data_directory
cfg_parent=cgiutils.cfg_directory
import time
timenow=time.time()

if debug:
    print('''<pre>/n/n 
    woi keys: '''+str(list(woi.keys()))+ '''\n\n
    woi.stdin: '''+str(woi.stdin)+'''\n\n
    woi.environ: '''+str(woi.environ)+'''\n\n
    </pre> ''')

def expire_unconfirmed(pending):
  ''' expires applications left unconfirmed longer than 3 days '''
  delrows=[] # list of keys to be deleted from applications table
  # confirmsecs is the number of seconds allowed for confirmation  
  confirmsecs=24*3600*3 # 3 days allowed until unconfirmed requests are removed 
  for row in pending.data:
    whenapplied=int(row["timestamp"])
    if whenapplied+confirmsecs < timenow :
      delrows.append(row["email"])
  for email in delrows:     
    pending.delrow(email)
  pending.save()

def send_confirmation(email,listname,v):
  domain=v['domain']
  fromad='no-reply@'+domain
  message="From: "+fromad+"\n"
  to_line="To: %s\n" % email
  message+=to_line
  message+="Subject: "+listname+" subscription complete \n\n"
  message+="You have subscribed to "+listname+" .\n"
  message+="\n"
  message+="In case of errors or issues, the contact for "+listname+" is "+ v['Listowner']+" .\n"
  message+="\n"
  cgiutils.send_mail(fromad,email,message)

def do_inserts(s,Vars):
  ''' less exception/bug prone %s format insertions in string '''
  for var in Vars:
      if '%s' in s and type(var) == type('string'):
          parts=s.split('%s',maxsplit=1)
          s=parts[0]+var+parts[1]
  return s

def send_code_by_email(email,listname,name,code,v):
  url=v['List-Subscribe']
  Vars=[url,email,listname,name,code]
  sub_link="Or use this link directly: %s?email=%s&listname=%s&name=%s&code=%s&sub=sub \n\n"
  sub_link=do_inserts(sub_link,Vars)
  domain=v['domain']
  fromad='no-reply@'+domain
  message="From: "+fromad+"\n"
  to_line="To: %s\n" % email
  message+=to_line
  message+="Subject: "+listname+" confirmation code \n\n"
  message+="Someone, presumably you, asked to subscribe to "+listname+" .\n"
  message+="You may complete the form by going back and entering code: "+str(code)+"\n"
  message+="\n"
  message+=sub_link
  message+="In case of errors, the contact for "+listname+" is "+ v['Listowner']+" .\n"
  message+="\n"
  cgiutils.send_mail(fromad,email,message)

def main():
  #cgiutils.html_header(title="Nextlist Mail Management System")
  session=False 
  listname=woi.firstval("listname")
  email=woi.firstval("email")
  formcode=woi.firstval("code")
  name=woi.firstval("name") 
  # Not required but check if usable if given 
  if name != '' and not cgiutils.is_person(name):
      cgiutils.html_end(session,
         error="Invalid name. Not required, but if given, use letters, space and chars '-. only.")
      return
  if len(list(woi.keys())) == 0 :
    # if no keys send the form to the browser
    cgiutils.html_header(title="Nextlist Mail Management System")
    print(cgiutils.send_form("sub.form",vars=[listname,email,'']))
    cgiutils.html_end(session,want_form=1)
    return
  elif not woi.has_required(["listname"]):
    cgiutils.html_header(title="Nextlist Mail Management System")
    cgiutils.html_end(session,
       error="You havn't input a listname.")
    return
  # need to check listname valid and exists. If it 
  # does, dl/listname folder must also exist
  if listname == '' or not cgiutils.is_valid(listname,allowed='^[a-z][a-z_]*$'):
    cgiutils.html_header(title="Nextlist Mail Management System")
    cgiutils.html_end(session,error="Missing or invalid listname.")
    return 
  # check list folder exists
  import os.path
  dl=os.path.join(data_parent,listname)
  cfgl=os.path.join(cfg_parent,listname,'list.cfg') # list config file
  if not os.path.exists(cfgl) :
    cgiutils.html_header(title="Nextlist Mail Management System")
    cgiutils.html_end(session,error="Listname not existent or not installed.")
    return
  # we can now get the list variables 
  v=cgiutils.get_vars(cfgl) # extract list config as directory
  listowner=v['Listowner']
  if v['Visibility'].lower() != 'public':
    cgiutils.html_header(title="Nextlist Mail Management System")
    cgiutils.html_end(session,
      error="List: "+listname+" is not a public list so you can't self subscribe to it. Please ask listowner "+listowner+".\n")
    return
  if email == '' or not cgiutils.is_email(email,deliv_check=True):
    cgiutils.html_header(title="Nextlist Mail Management System")
    cgiutils.html_end(session,error="Missing or invalid email.")
    return
  email=cgiutils.normalise_email(email)
  # OK we have an email and list name. Is the email a member ?
  option="none" 
  for word in ["sub","send"]:
    if word in woi.keys():
      option=word
  if option=="none": 
    cgiutils.html_header(title="Nextlist Mail Management System")
    cgiutils.html_end(session,error="Invalid submit button value.")
    return
  # OK we have an email and list name
  addrtab=tablcgi.table(laddr,dir=dl)
  pending=tablcgi.table(pendsub,dir=dl)
  expire_unconfirmed(pending) # needed to remove 3day old timed out data from pending table
  if option in ["sub","send"]:
    if email in addrtab.keys():
      cgiutils.html_header(title="Nextlist Mail Management System")
      cgiutils.html_end(session,error="You are already a list member so don't need to subscribe.")
      return
  else:
    cgiutils.html_header(title="Nextlist Mail Management System")
    cgiutils.html_end(session,error="Invalid form option.")
    return
  # have sub or send option check code 
  pindex=pending.find(email) # if not in pending, add record to pending
  if pindex == -1:
    validcode=cgiutils.make_pin(mini=100000,maxi=999999)
    prow={}
    prow['email']=email
    prow['name']=name
    prow["code"]=str(validcode)
    prow['timestamp']=timenow
    pending.addrow(prow)
    pending.save()
  else:
    validcode=pending.data[pindex]['code']
  if option == "send": # email confirmation required
    # TBD add row to pending table
    cgiutils.html_header(title="Nextlist Mail Management System")
    send_code_by_email(email,listname,name,validcode,v)
    url=v['List-Subscribe']
    print("<p> Subscription confirmation code sent to your email.</p>")
    print("<p> The email with this code contains a one click")
    print(" confirmation link, or you may input your listname, ")
    print(' address and code sent to your email into the webform <a href="'+url+'">'+url+'</a> to confirm.</p>')
    cgiutils.html_end(session,received=1)
  elif option == "sub": # code validation required
    if pindex == -1:
      # can't confirm if no pending data
      cgiutils.html_header(title="Nextlist Mail Management System")
      cgiutils.html_end(session,
         error="Need to validate email address using a code before subscription can be confirmed.")
      return
    else:
      prow=pending.data[pindex]
    if not woi.has_required(["code"]):
      cgiutils.html_header(title="Nextlist Mail Management System")
      cgiutils.html_end(session,
         error="You havn't provided a subscribe code.")
      return
    if formcode == '' or not cgiutils.is_valid(formcode,allowed='^[0-9]*$'):
      cgiutils.html_header(title="Nextlist Mail Management System")
      cgiutils.html_end(session,error="Missing or invalid subscribe code.")
      return 
    if int(formcode) != int(validcode): # wrong subscribe code input
      cgiutils.html_header(title="Nextlist Mail Management System")
      cgiutils.html_end(session,error="Incorrect subscribe code.")
      return
    # OK, we have a valid sub request. Process it by adding new list member.
    arow={}
    # prefer form of email as in pending, to form version
    arow['email']=prow['email']
    # prefer longer name if both aren't the same. Possible 1 may be empty
    if len(name) > len(prow['name']):
      arow['name']=name
    else:
      arow['name']=prow['name']
    if v['WhoCanPost'].lower() == 'member': 
      arow['moderated']='N' # not moderated
    else:
      arow['moderated']='Y' # moderated by default - only list owner can post
    unsubcode=cgiutils.make_pin(mini=100000,maxi=999999)
    # random code used in unsubscribe operations requiring unsubscriber
    # to have access to a list email sent to unsubscription address
    arow["code"]=str(unsubcode)
    addrtab.addrow(arow) # add record to address list
    pending.delrow(arow['email']) # remove row from pending
    addrtab.save()
    cgiutils.html_header(title="Nextlist Mail Management System")
    send_confirmation(email,listname,v)
    print("<p> Subscription successful </p>")
    cgiutils.html_end(session,received=1)
    return 
  else:
    # should have trapped this one earlier ???
    cgiutils.html_header(title="Nextlist Mail Management System")
    cgiutils.html_end(session,error="Invalid option value (2nd trap).")
  return 

if __name__ == "__main__":
  try: 
    main()
  except:
    import traceback
    print("error detected in sub.cgi main()")
    traceback.print_exc()

