#!/bin/env python
''' looks in attached directory relative to webroot 
and recursively removes timed out random number
named directories under the listname parents
based on number of days these are retained for
in per list policy. '''

import cgiutils
import glob
import os
import os.path
import time
now=time.time() # time in secs since epoch
import shutil
cfg_directory=cgiutils.cfg_directory
web_directory=cgiutils.web_directory
email_directory=cgiutils.email_directory

def main():
  # get paths of lists likely to have attachments
  attach_dir=os.path.join(web_directory,'attached')
  listglob=os.path.join(attach_dir,'*')
  listnamepaths=glob.glob(listglob)
  basenames=[] # get list name candidates
  for path in listnamepaths:
    basenames.append(os.path.basename(path))
  # store timeouts per list in dictionary
  lists_with_timeout_policy={}
  for basename in basenames:
    cfg_file=os.path.join(cfg_directory,basename,'list.cfg')
    if os.path.isfile(cfg_file):
      v=cgiutils.get_vars(cfg_file) # extract list config as directory
      # need lifetime in days for attachments
      days=v['DownloadDays']
      lists_with_timeout_policy[basename]=int(days)
  print('lists which timeout attachments: '+str(lists_with_timeout_policy))
  # process policies per list
  lists=lists_with_timeout_policy.keys()
  for listname in lists:
      timeoutdays=lists_with_timeout_policy[listname]
      listatt_path=os.path.join(web_directory,'attached',listname)
      ndirglob=os.path.join(listatt_path,'[0-9]*')
      ndirs=glob.glob(ndirglob) # per listname list of paths of numbered folders
      print('processing '+str(ndirs)+' with timeout policy '+str(timeoutdays))
      for folder in ndirs:
        age_secs=int(now - os.path.getmtime(folder))
        age_mins=age_secs//60
        age_hours=age_mins//60
        age_days=age_hours//24
        print('age of folder in days: '+folder+' is '+str(age_days))
        if age_days > timeoutdays:
          print('moving: '+folder+' to /tmp')
          # recursively move folder and contents to /tmp
          shutil.move(folder,'/tmp')

if __name__ == '__main__':
    main()
