#!/usr/bin/env python

# change next line to 1 to debug script
debug=0

""" entry.cgi This file is the list admin login for a
    Richard Kay last changed: 29 Nov 2023
"""

if debug:
  import sys
  sys.stderr=sys.stdout
  print("Content-type: text/plain\n")

import cgiutils
import webinput
woi=webinput.Webinput() 
import tablcgi
from table_details import laddr
data_parent=cgiutils.data_directory
cfg_parent=cgiutils.cfg_directory
# need to get valid listname before we can input
# list configuration vars and table.
if debug:
    print('''<pre>/n/n 
    woi keys: '''+str(list(woi.keys()))+ '''\n\n
    woi.stdin: '''+str(woi.stdin)+'''\n\n
    woi.environ: '''+str(woi.environ)+'''\n\n
    </pre> ''')

def send_pin(email,listname,v):
  domain=v['domain']
  pin=v['ownerpin']
  fromad='no-reply@'+domain
  message="From: "+fromad+"\n"
  to_line="To: %s\n" % email
  message+=to_line
  message+="Subject: "+listname+" PIN request \n\n"
  message+="Someone (hopefully you) entered your list id\n"
  message+="and email address requesting a PIN for your account.\n"
  message+="\n"
  pin_line="The PIN you will need for access is: %s\n" % pin
  message+=pin_line
  message+="\n"
  message+="If you didn't request your PIN, please ignore this message.\n"
  message+="However, if this error persists please contact\n"
  message+=v['abuse']+" .\n"
  message+="\n"
  cgiutils.send_mail(fromad,email,message)
  cgiutils.html_header(title="Nextlist Mail Management System")
  print("<p>The PIN for the account has been sent as requested.</p>")
  cgiutils.html_end(received=1)

def main():
# cgiutils.html_header(title="Nextlist Mail Management System")
  session=False 
  if len(list(woi.keys())) == 0:
    # if no keys send the form to the browser
    # include a logout which clears the form 
    cgiutils.html_header(title="Nextlist Mail Management System")
    print(cgiutils.send_form("entry.form",vars=["",""]))
    cgiutils.html_end(session,want_form=1)
    return
  elif not woi.has_required(["listname"]):
    cgiutils.html_header(title="Nextlist Mail Management System")
    cgiutils.html_end(session,
       error="You havn't input a listname.")
    return
  listname=woi.firstval("listname")
  # need to check listname valid and exists. If it 
  # does, dl/listname folder must also exist
  if listname == '' or not cgiutils.is_valid(listname,allowed='^[a-z][a-z_]*$'):
    cgiutils.html_header(title="Nextlist Mail Management System")
    cgiutils.html_end(session,error="Missing or invalid listname.")
    return 
  # check list folder and list.cfg exists
  import os.path
  dl=os.path.join(data_parent,listname)
  cfgl=os.path.join(cfg_parent,listname,'list.cfg') # list config file
  if not os.path.exists(cfgl) :
    cgiutils.html_header(title="Nextlist Mail Management System")
    cgiutils.html_end(session,error="Listname not existent or uninstalled.")
    return
  # we can now get the list variables and confirm admin email and PIN.
  # has listname - process email
  v=cgiutils.get_vars(cfgl) # extract list config as directory
  email=woi.firstval("email")
  if not cgiutils.is_alias(email):
    cgiutils.html_header(title="Nextlist Mail Management System")
    cgiutils.html_end(session,error="authentication failure:a")
    return
  # OK we have an email and list name. Does the config
  # variable for the list correspond ?
  valid_email=v['obscure_email']
  if email.lower() != valid_email.lower() :
    cgiutils.html_header(title="Nextlist Mail Management System")
    cgiutils.html_end(session,error="authentication failure:b")
    return
  # OK we have an email for owner and list name. What is the valid PIN 
  # valid for this listowner 
  valid_pin=v['ownerpin']
  # which submit button was pressed ?
  option="none"
  for word in ["sendpin","login"]:
    if word in woi.keys():
      option=word

  if option=="none": 
    cgiutils.html_header(title="Nextlist Mail Management System")
    cgiutils.html_end(session,error="Invalid submit button value.")
    return
  
  # check if a PIN was entered and validate it
  pinentry=woi.firstval("pin",default="")
  if pinentry and not cgiutils.is_valid(pinentry,allowed=r'^[1-9][0-9]+$'):
    cgiutils.html_header(title="Nextlist Mail Management System")
    cgiutils.html_end(session,error="Incorrect PIN entered.")
    return
  if pinentry and str(pinentry) != str(valid_pin):
      cgiutils.html_header(title="Nextlist Mail Management System")
      cgiutils.html_end(session,error="Incorrect PIN entered.")
      return
  # OK we have an email for owner and list name and valid pin
  elif pinentry == '' and not option == "sendpin":
    # Without a valid pin actions other than sending pin are prohibited
    cgiutils.html_header(title="Nextlist Mail Management System")
    cgiutils.html_end(session,error="No PIN entered.")
    return
  # If we've got this far, there should either be a valid option and PIN
  # or we have a PIN request.
  if option == "sendpin":
    # check correct email registered for account entered
    if valid_email.lower() != email.lower():
      cgiutils.html_header(title="Nextlist Mail Management System")
      cgiutils.html_end(session,
         error="Incorrect email address, can't send PIN.")
      return
    send_pin(email,listname,v)
    return
  elif option == "login":
    # All OK sofar. Send the main menu form
    pagesize='20' # needed by admin form for paged viewing
    pageidx='0' # ditto
    cgiutils.html_header(title="Nextlist Mail Management System",
                         bgcolor='"#FFFFFF"')
    print(cgiutils.send_form("admin.form",
      vars=[listname,email,pinentry,listname,pagesize,pageidx]))
    cgiutils.html_end(session,want_form=1)
    return 
  else:
    # should have trapped this one earlier ???
    cgiutils.html_header(title="Nextlist Mail Management System")
    cgiutils.html_end(session,error="Invalid option value (2nd trap).")
  return 

if __name__ == "__main__":
  try: 
    main()
  except:
    import traceback
    print("error detected in entry.cgi main()")
    traceback.print_exc()

