#!/usr/bin/env python

# change next line from 0 to 1 to debug script

debug=0

""" admin.cgi This file handles input from the 
    form used to create/delete/view/modify email list
    memberships.
    Richard Kay 
    Last changed  09 Nov 2023
"""

if debug:
  import sys
  sys.stderr=sys.stdout
  print("Content-type: text/plain\n")

import cgiutils
import webinput
woi=webinput.Webinput()
import tablcgi
from table_details import laddr
data_parent=cgiutils.data_directory
cfg_parent=cgiutils.cfg_directory
session=False

def auth():
  if not woi.has_required(['email','pin','listname']):
      # authentication hidden fields not present
    cgiutils.html_end(session,error="Administrator login required.")
    return False, []
  listname=woi.firstval("listname")
    # need to check listname valid and exists. If it 
    # does, dl/listname folder must also exist
  if not cgiutils.is_valid(listname,allowed='^[a-z][a-z_]*$'):
      cgiutils.html_header(title="Nextlist Mail Management System")
      cgiutils.html_end(session,error="Invalid characters in listname.")
      return False, [] 
  # check list folder exists
  import os.path
  dpath=os.path.join(data_parent,listname)
  cfgl=os.path.join(cfg_parent,listname,'list.cfg') # list config file
  if not os.path.exists(cfgl) :
    cgiutils.html_header(title="Nextlist Mail Management System")
    cgiutils.html_end(session,error="Listname not existent or uninstalled.")
    return False, []
  # we can now get the list variables and confirm admin email and PIN.
  # has listname - process email
  v=cgiutils.get_vars(cfgl) # extract list config as directory
  dl=os.path.join(data_parent,listname)
  email=woi.firstval("email")
  if not cgiutils.is_alias(email):
    cgiutils.html_header(title="Nextlist Mail Management System")
    cgiutils.html_end(session,error="Invalid email.")
    return False, []
  # OK we have an email and list name. Does the config
  # variable for the list correspond ?
  valid_email=v['obscure_email']
  if email.lower() != valid_email.lower() :
    cgiutils.html_header(title="Nextlist Mail Management System")
    cgiutils.html_end(session,error="Email address is not listowner.")
    return False, []
  # OK we have an email alias for owner and list name. What is the valid PIN 
  # valid for this listowner 
  valid_pin=v['ownerpin']
  # check if a PIN was entered and validate it
  pinentry=woi.firstval("pin",default="")
  if not pinentry: # not valid here
    cgiutils.html_header(title="Nextlist Mail Management System")
    cgiutils.html_end(session,error="No PIN input")
    return False, []
  if not cgiutils.is_valid(pinentry,allowed=r'^[1-9][0-9]+$'):
    cgiutils.html_header(title="Nextlist Mail Management System")
    cgiutils.html_end(session,error="Incorrect PIN entered.")
    return False, []
  if str(pinentry) != str(valid_pin):
    cgiutils.html_header(title="Nextlist Mail Management System")
    cgiutils.html_end(session,error="Incorrect PIN entered.")
    return False, []
  return True, [email,pinentry,listname,v,dpath,cfgl]

def main():
  session=False
  cgiutils.html_header(title="Nextlist Mail Management System",
                       bgcolor='"#FFFFFF"')
  valid,authvals=auth()
  if not valid:
    return # error message already sent
  email=authvals[0]
  pinentry=authvals[1]
  listname=authvals[2]
  v=authvals[3]
  dpath=authvals[4]
  cfgfile=authvals[5]
  valid,option=cgiutils.get_option(woi,buttons=[
      "admin","add","modify","delete","view","next","bulkadd","reset"])
  if not valid:
    return # error message already sent
  # we now have a valid list admin login and view/add/mod/del option
  addrtab=tablcgi.table(laddr,dir=dpath)
  if option == "admin": # just re-present admin form
    valid,psize,pidx=get_page_size_idx()
    # need to reset pidx when we're sent back here
    pidx=0
    if not valid:
      return # error already sent
    print(cgiutils.send_form("admin.form",
      vars=[listname,email,pinentry,listname,str(psize),str(pidx)]))
    cgiutils.html_end(session,want_form=1)
    return
  if option == "bulkadd": # present/process bulk addition form
    raw_additions=woi.firstval("addresses",default='')
    if raw_additions == '':
      print(cgiutils.send_form("bulkadd.form",
        vars=[email,pinentry,listname]))
      cgiutils.html_end(session,want_form=1)
      return
    else:
      #print('<p>have raw_additions<p>')
      moderated=woi.firstval("moderated",default='N').upper()
      # print('<p>have moderated: %s <p>' % moderated)
      if moderated not in 'YN':
        cgiutils.html_end(session,
          error="Moderation flag must be Y or N",back=1)
        return
      # process bulk additions
      # print('<p>importing address_textio<p>')
      import address_textio
      # print('<p>imported address_textio<p>')
      added=address_textio.bulk_add(data_parent,
            listname,raw_additions,moderated=moderated)
      # print('<p> %d addresses added to list: %s </p>' % (added,listname))
      print(cgiutils.send_form("admin.form",
        vars=[listname,email,pinentry,listname,str(20),str(0)]))
      cgiutils.html_end(session,want_form=1,back=1)
      return
  #
  if option == "add": # need details for new member 
    if not woi.has_required(["name","membemail","moderated"]):
      cgiutils.html_end(session,
        error="Missing field for add member. Complete all fields.",
        back="adminback.form",vars=[email,pinentry,listname,str(20),str(0)])
      return
    # validate fields
    name=woi.firstval("name")
    name=cgiutils.make_clean(name,prohibited=None) # allows only letters, -_'
    if name != '' and not cgiutils.is_person(name):
      cgiutils.html_end(session,
        error="Invalid name. Use letters, space and chars '-. only.",
        back="adminback.form",vars=[email,pinentry,listname,str(20),str(0)])
      return
    membemail=woi.firstval("membemail")
    if not cgiutils.is_email(membemail,deliv_check=True):
      import validemail
      errormes="Invalid email address: "+validemail.normalise_email(membemail,check_deliv=True)
      cgiutils.html_end(session, error=errormes,
      back="adminback.form",vars=[email,pinentry,listname,str(20),str(0)])
      return
    membemail=cgiutils.normalise_email(membemail,deliv_check=True)
    if membemail in addrtab.keys():
      error="Email address already a list member. Can't add it."
      cgiutils.html_end(session,error,
      back="adminback.form",vars=[email,pinentry,listname,str(20),str(0)])
      return
    moderated=woi.firstval("moderated").upper()
    if not cgiutils.is_valid(moderated,max_leng=1,
        allowed='^[ynYN]$'):
      cgiutils.html_end(session,error="Moderated entry must be Y or N",
      back="adminback.form",vars=[email,pinentry,listname,str(20),str(0)])
      return

    # if still here add row to list members table
    row={}
    row["name"]=name
    row["email"]=membemail
    row["moderated"]=moderated
    code=cgiutils.make_pin(mini=100000,maxi=999999)
    # random code used in unsubscribe operations requiring unsubscriber 
    # to have access to a list email sent to unsubscription address
    row["code"]=str(code)
    addrtab.addrow(row)
    addrtab.sort()
    addrtab.save()
    print("<p>new list member added</p>")
    cgiutils.html_end(session,received=1,
    back="adminback.form",vars=[email,pinentry,listname,str(20),str(0)])
    return
  elif option == "modify": # modify details for member 
    membemail=woi.firstval("membemail")
    modifications=0 # counts number of fields changed
    # check account does exist
    if membemail not in addrtab.keys():
      error="Email address not a list member. Can't modify."
      cgiutils.html_end(session,error,
        back="adminback.form",vars=[email,pinentry,listname,str(20),str(0)])
      return
    else: # get member row index 
      mindex=addrtab.find(membemail)

    # check moderation flag 
    if "moderated" in woi.keys():
      # validate field
      oldmod=addrtab.data[mindex]["moderated"]
      moderation=woi.firstval("moderated").upper()
      if moderation not in ['Y','N']:
        cgiutils.html_end(session,
          error="Moderation code must be Y or N.",
          back="adminback.form",vars=[email,pinentry,listname,str(20),str(0)])
        return
      if moderation != oldmod: # dont register change unless different
        addrtab.data[mindex]["moderated"]=moderation
        modifications+=1
    # check name 
    if "name" in woi.keys():
      # validate field
      oldname=addrtab.data[mindex]["name"]
      newname=woi.firstval("name")
      newname=cgiutils.make_clean(newname,prohibited=None) # allows letters, -_'
      if newname != '' and not cgiutils.is_person(newname):
        cgiutils.html_end(session,
          error="Invalid name. Use letters, space and chars '-. only.",
          back="adminback.form",vars=[email,pinentry,listname,str(20),str(0)])
      if newname not in ['',oldname]: 
        addrtab.data[mindex]["name"]=newname
        modifications+=1
    if modifications: # save changes to members table if any
      addrtab.save()
      print("<p> %d field/s modified.</p>" % modifications)
      cgiutils.html_end(session,received=1,
        back="adminback.form",vars=[email,pinentry,listname,str(20),str(0)])
      return
    else: # all changeable fields were blank 
      cgiutils.html_end(session,error="No modified field values submitted.",
        back="adminback.form",vars=[email,pinentry,listname,str(20),str(0)])
      return
  elif option == "delete":
    membemail=woi.firstval("membemail")
    if membemail not in addrtab.keys():
      error="Member email doesn't exist. Can't delete it."
      cgiutils.html_end(session,error,
        back="adminback.form",vars=[email,pinentry,listname,str(20),str(0)])
      return
    # mindex=addrtab.find(membemail)
    addrtab.delrow(membemail)
    cgiutils.html_end(session,received=1,
      back="adminback.form",vars=[email,pinentry,listname,str(20),str(0)])
    return
  elif option == "view" or option == "next":
    # view list members as paged html table
    # create view table for page
    valid,psize,pidx=get_page_size_idx()
    if not valid:
      return # error already sent
    view_def=tablcgi.table_def(addrtab) # clone don't copy
    view_def.file=None # memory object only
    addrp=tablcgi.table(view_def) # view page table
    # insert records into view table
    lowest=pidx
    highest=pidx+psize
    # print('<pre>lowest: %d highest %d rows in addrtab %d\n\n' % (
    #    lowest,highest,len(addrtab.data)))
    count=0
    ndisp=0
    nrows=len(addrtab.data)
    for row in addrtab.data:
      if count >= lowest and count < highest:
        # print('count %d adding row %s \n\n' % (count,str(row)))
        addrp.addrow(row)
        ndisp+=1
      count+=1
    addrp.tab2html(skip_cols=['code'])
    if nrows == 0:
      print('<p>Empty list. No list membership to display</p>')
    elif ndisp == 0 or highest > nrows:
      print('<p>End of listing. No more pages to display</p')
    pageidx=str(highest)
    print(cgiutils.send_form("viewpage.form",
      vars=[email,pinentry,listname,str(psize),pageidx]))
    cgiutils.html_end(session,want_form=1)
    return
  elif option == "reset":
    # reset admin PIN 
    newpin=str(cgiutils.make_pin(mini=100000000000000,maxi=999999999999999))
    import list_configure
    list_configure.modify_config_var(cfgfile,'ownerpin',newpin)
    print(
    '<p>Your PIN has been reset. Press SEND PIN to obtain new pin by email</p>')
    print(cgiutils.send_form("entry.form",
      vars=[listname,email]))
    cgiutils.html_end(session,want_form=1)
    return

def get_page_size_idx():
    # print('woi keys: '+str(woi.keys()) + '\n\n') 
    pagesize=woi.firstval("page",default='')
    if not pagesize: # called page first time around
      pagesize=woi.firstval("pagesize",default='20')
    if not cgiutils.is_valid(pagesize,max_leng=3,
        allowed='^[0-9]+$'):
        cgiutils.html_end(session,
        error="Invalid page size must be numeric.",
        back="adminback.form",vars=[email,pinentry,listname,str(20),str(0)])
        return (False,0,0)
    pageidx=woi.firstval("pageidx",default='0')
    if pageidx != '' and not cgiutils.is_valid(pageidx,max_leng=6,
        allowed='^[0-9]+$'):
        cgiutils.html_end(session,
        error="Invalid page index must be numeric.",
        back="adminback.form",vars=[email,pinentry,listname,str(20),str(0)])
        return (False,0,0)
    # print('page size: '+str(pagesize)+'\n\n')
    # print('page index: '+str(pageidx)+'\n\n')
    try:
      psize=int(pagesize)
      pidx=int(pageidx)
    except:
      cgiutils.html_end(session,
      error="Invalid page size or index not convertable to number.",
        back="adminback.form",vars=[email,pinentry,listname,str(20),str(0)])
      return (False,0,0)
    return (True,psize,pidx)

if __name__ == "__main__":
  try:
      main()
  except:
    import traceback
    print("error detected in admin.cgi main()")
    traceback.print_exc()

