'''A Python 3 email address import/export module.
  Richard Kay, 9 Dec 2023 Can be used like this: 
      import address_textio
      added=address_textio.bulk_add(listname,dpath,raw_additions)
      print('<p> %d addresses added to list: %s </p>' % (added,listname))
'''

import cgiutils
import tablcgi
import validemail

def strip_cr_lf(inheader):
  # Policy seems to dislike multiline headers
  outheader=""
  for char in inheader:
    if char in "\r\n\t":
      pass
    else:
      outheader+=char
  return outheader

def stripwhite(s):
  ''' removes whitespace at start and end of string '''
  while( s and s[0] in [' ','\n','\t','\r']):
    s=s[1:]
  while( s and s[-1] in [' ','\n','\t','\r']):
    s=s[:-1]
  return s

def make_to_address(email,name):
  ''' outputs in format 
  Person Name <someone@example.com>
  '''
  addline=name+' <'+email+'>'
  return addline

def get_list(homedir,listname):
  ''' returns email address db object. '''
  from table_details import laddr
  import os.path
  pathn=os.path.join(homedir,listname)
  lmtab=tablcgi.table(laddr,dir=pathn)
  return lmtab 

def search_line(search,strlist):
  # returns position of string in list or -1 if no exact match found
  count=0
  for item in strlist:
      if item == search: # found return position
          return count
      count+=1
  return -1

def just_address(s):
  ''' returns just lowercase address part of string of form
  'Example Person <person@example.com>'   '''
  import re
  s=stripwhite(s)
  cre=re.compile('<.*>')
  mo=cre.search(s)
  if type(mo) == type(None) :
    return s.lower()
  else:
    return mo.group()[1:-1].lower()

def just_name(s): 
  ''' returns just Name part of string of form
  'Example Person <person@example.com>'   '''
  idx=search_line('<',s)
  if idx == -1: # no opening < bracket
    s=stripwhite(s)
    return s
  else:
    return stripwhite(s[0:idx])

def bulk_add(homedir,listname,raw_additions,moderated='N'):
    assert moderated in 'ynYN'
    addrtab=get_list(homedir,listname)
    additions=raw_additions.split('\n')
    print('<p> Attempting to validate and add %d addresses to list %s</p>'
          % (len(additions),listname))
    errors=0
    adds=0
    for line in additions:
       valid=True # innocent until proven guilty
       if '<' not in line:
         name='' # just address in line, no name
       else:
         name=just_name(line)
         # remove dodgy characters from name
         name=cgiutils.make_clean(name,prohibited=None) # allows only letters, -_'
       if name != '' and not cgiutils.is_person(name):
         print('invalid character/s in name %s so not adding this line.<br>' % name)
         errors+=1
         valid=False
         next
       address=just_address(line)
       if not validemail.is_email(address,check_deliv=True):
         print('invalid address %s checking reason.<br>' % address)
         errormes=validemail.normalise_email(address,check_deliv=True)
         print('reason invalid %s so not adding this line.<br>' % errormes)
         errors+=1
         valid=False
         next
       # get normalised form of address
       norm_address=validemail.normalise_email(address)
       # OK we have validated email check it exists
       if norm_address in addrtab.keys():
         print('address %s already in list so not adding this line.<br>' % norm_address)
         errors+=1
         valid=False
         next
       # if still here add row to list members table
       if valid:
         row={}
         row["name"]=name
         row["email"]=norm_address
         row["moderated"]=moderated
         code=cgiutils.make_pin(mini=100000,maxi=999999)
         # random code used in unsubscribe operations requiring unsubscriber 
         # to have access to a list email sent to unsubscription address
         row["code"]=str(code)
         addrtab.addrow(row)
         addrtab.sort()
         addrtab.save()
         adds+=1
         print("new list member added for input: %s <br>" % line)
    print("<p>%d additions and %d lines not added</p>" % (adds,errors))
    return adds

