#!/bin/bash
#
# Script to assemble sources for nextlist email list management program
# and create distributable archive (tgz) file from live system.
# Assumes etc/default_paths.py is within the folder from which this
# program make_tgz.sh is run

if [ ! -f etc/default_paths.py ]; then
	echo cant find etc/default_paths.py from here. Relocate and rerun
	echo fatal error - ending now
	exit
fi
global_dir=$(cat etc/default_paths.py | fgrep global_dir= | sed s/\'//g | sed s/global_dir=// )
echo global_dir is $global_dir
cfg_dir=$(cat etc/default_paths.py | fgrep cfg_dir= | sed s/\'//g | sed s/cfg_dir=// )
echo cfg_dir is $cfg_dir
web_dir=$(cat etc/default_paths.py | fgrep web_dir= | sed s/\'//g | sed s/web_dir=// )
echo web_dir is $web_dir
email_dir=$(cat etc/default_paths.py | fgrep email_dir= | sed s/\'//g | sed s/email_dir=// )
echo email_dir is $email_dir
mypid=$$
echo mypid is $$
tmp_dir=/tmp/$mypid
echo tmp_dir is $tmp_dir
if [ -d $tmp_dir ]; then
	$tmp_dir exists already. Remove it and rerun
	echo make_tgz.sh failed due to path conflict
	exit
fi
mkdir $tmp_dir
mkdir $tmp_dir/nextlist

# process web directory
cp -r $web_dir $tmp_dir/nextlist/web
# remove temporary, stored attachment and log files
rm -rf $tmp_dir/nextlist/web/__pycache__
rm -rf $tmp_dir/nextlist/web/attached
rm  $tmp_dir/nextlist/web/*.log 
rm  $tmp_dir/nextlist/web/nextlist.tgz 
rm  $tmp_dir/nextlist/web/nextlist.tgz.bak

# process email directory
cp -r $email_dir $tmp_dir/nextlist/email
# remove setuid from copy of wrapper if still present
chmod -s $tmp_dir/nextlist/email/wrapper
# remove temporary python cache and exported address data
rm -rf $tmp_dir/nextlist/email/__pycache__
rm -rf $tmp_dir/nextlist/email/exports

# process default list config directory
mkdir $tmp_dir/nextlist/lists
cp -r $cfg_dir/defaults $tmp_dir/nextlist/lists
# process global etc directory
cp -r $global_dir $tmp_dir/nextlist/etc
# process global docs directory
mkdir $tmp_dir/nextlist/docs
cp -r ./docs/* $tmp_dir/nextlist/docs
# remove temporary files
rm -rf $tmp_dir/nextlist/etc/__pycache__
# copy files in current working directory
cp *sh *py *TXT $tmp_dir/nextlist
# Now make TGZ file
cd $tmp_dir
tar czvf nextlist.tgz nextlist
echo your archive is temporarily stored here: $tmp_dir/nextlist.tgz
echo backing up distribution version stored here: $web_dir/nextlist.tgz.bak
mv $web_dir/nextlist.tgz $web_dir/nextlist.tgz.bak
echo copying new distribution version to here: $web_dir/nextlist.tgz
cp $tmp_dir/nextlist.tgz $web_dir
chown -R nextlist:nextlist $web_dir/*
echo make_tgz.sh completed
