#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>

/* wrapper.c - program to run nextlist.py with
 * uid and gid changed (postfix runs email handlers uid/gid nobody) 
 * selected with group giving
 * read access to address.pkl files
 * location and modes of these, should be mode 640 (rw-r-----).
 * uid and gid should be the same as the setuid web application 
 * or use numeric values corresponding to www-data for user
 * and group if web server virtual domain not running mod setuid. 
 *
 * compile using command 
  gcc -o wrapper wrapper.c
 * Which depends on package build-essential being installed.
 * and make setuid root by ensuring root ownership and with command 
 chmod u+s wrapper
*/ 

int main(int argc,char** argv){
  uid_t uid,myuid; /* integer type for storing numeric UID */
  gid_t mygid; /* integer type for storing numeric GID */
  /* edit next lines for absolute path of nextlist.py email handing program
   * only if installed somewhere different. Normally
   * installed in same directory as this wrapper.c program code */
  char *emhandler="/usr/local/nextlist/email/nextlist.py" ; 
  /* comment above line and uncomment next line to test setgid wrapper executable */ 
  /* char *emhandler="/usr/local/nextlist/email/testwrapper.sh" ; */ 
  if (argc != 5){
    fprintf(stderr,"usage: wrapper listname domainname UID GID\n");
    exit(1);
  } 
  uid=getuid();
  myuid=(uid_t)atoi(argv[3]);
  mygid=(gid_t)atoi(argv[4]);
  setgid(mygid); /* need to do this first ? */
  setuid(myuid);
  /* replace current setuid program with non setuid script */
  execlp(emhandler,emhandler,argv[1],argv[2],NULL);
  printf("If you see this, the execlp() call has failed\n");
  return 0; /* so we compile without a warning */
}

