#!/usr/bin/python3
#
# utilities required by nextmail.py program are collected here
# 
import sys
import os
# modify next line to where global configuration default_paths.py is installed
global_config_dir='/usr/local/nextlist/etc'
global_config_default_paths=os.path.join(global_config_dir,"default_paths.py")
if not os.access(global_config_default_paths, os.R_OK):
  senderror(None,"cgiutils warning: path module location "+global_config_default_paths+" not readable.")
  sys.exit(1)
try:
  sys.path.append(global_config_dir)
  import default_paths
  cfg_directory=default_paths.cfg_dir
  data_directory=default_paths.data_dir
  web_directory=default_paths.web_dir
  email_directory=default_paths.email_dir
  # sw_directory=default_paths.sw_directory
except: 
  senderror(None,"module imports from location "+global_config_dir+" failed.")
  sys.exit(1)

webmodulepath=web_directory
if not os.access(webmodulepath, os.R_OK):
      senderror(None,"python module location "+webmodulepath+" not readable.")
try:
  sys.path.append(webmodulepath)
except: 
  senderror(None,"module imports from location "+webmodulepath+" failed.")
  sys.exit(1)
#
# Import smtplib for the actual sending function
import smtplib
import email
# Import the email modules we'll need
from email.message import EmailMessage
from email import parser

def senderror(toaddr,errormesg,subject="Nextlist Email Message Bounce"):
  if not toaddr: # dont know who to send this to
    sys.exit(errormesg)
  outm=EmailMessage()
  outm.add_header('Subject',subject)
  outm.set_content("\n\n"+errormesg+"\n\n")
  # need to create a member row for mail_to_recipient, but 
  # we don't know name
  memberrow={'email':toaddr,'name':''}
  mail_to_recipient(outm,memberrow)
  sys.exit(0)

def just_address(s):
  ''' returns just lowercase address part of string of form
  'Example Person <person@example.com>'   '''
  import re
  s=stripwhite(s)
  cre=re.compile('<.*>')
  mo=cre.search(s)
  if type(mo) == type(None) :
    return s.lower()
  else:
    return mo.group()[1:-1].lower()

def mail_to_recipient(outm,memberrow):
  toaddr=memberrow['email']
  if memberrow['name']:
      toaddr=memberrow['name']+' <'+toaddr+'>'
  # Send the message via our own SMTP server.
  if outm['To']: # if header exists, replace
    outm.replace_header('To',toaddr)
  else: # otherwise add new header
    outm.add_header('To',toaddr)
  if outm['From']: # if header exists leave as is
    fromaddr=outm['From']
  else: # otherwise add new header
    fromaddr='no-reply'
    outm.add_header('From','no-reply')
  s = smtplib.SMTP('localhost')
  s.send_message(outm,from_addr=fromaddr,to_addrs=toaddr)
  s.quit()
# end of main()

def strip_cr_lf(inheader):
  # Policy seems to dislike multiline headers
  outheader=""
  for char in inheader:
    if char in "\r\n\t":
      pass
    else:
      outheader+=char
  return outheader

def clean_filename(filename):
  # gets rid of chars in a filename which need web encoding 
  cleaned=""
  for char in filename:
    if char.lower() not in "abcdefghijklmnopqrstuvwxyz0123456789._":
      pass
    else:
      cleaned+=char
  return cleaned

def stripwhite(s):
  ''' removes whitespace at start and end of string '''
  while( s and s[0] in [' ','\n','\t','\r']):
    s=s[1:]
  while( s and s[-1] in [' ','\n','\t','\r']):
    s=s[:-1]
  return s

def make_to_address(email,name):
  ''' outputs in format 
  Person Name <someone@example.com>
  '''
  addline=name+' <'+email+'>'
  return addline

def get_list(homedir,listname):
  ''' returns email address db object. '''
  import cgiutils
  import tablcgi
  from table_details import laddr
  import os.path
  full_pathn=os.path.join(homedir,listname,laddr.file)
  if not os.access(full_pathn, os.R_OK):
      senderror(None,"address database: "+full_pathn+" not readable.")
  pathn=os.path.join(homedir,listname)
  lmtab=tablcgi.table(laddr,dir=pathn)
  return lmtab 

def search_line(search,strlist):
  # returns position of string in list or -1 if no exact match found
  count=0
  for item in strlist:
      if item == search: # found return position
          return count
      count+=1
  return -1

def del_member(filename,address):
  # removes line containing address from filename
  address=just_address(address)
  cleaned=get_list(filename)
  alldata=get_list(filename,clean=False)
  if cleaned == []: # empty list
      return False
  # identify line no. to remove
  found=search_line(address,cleaned)
  if found == -1:
      return False
  import fasteners
  lock = fasteners.InterProcessLock(filename+'.lock') # process lock
  with lock:
    fh=open(filename,'w') # open configuration file
    pos=0
    for row in alldata:
        if pos != found:
            fh.write(row) # write all rows except one to be removed
        pos+=1
    return True

def get_vars(filename,cfgdir=None,datadir=None,swdir=None):
  ''' reads config variables, from a config file. 
      The config file must have lines as in the following
      2 example lines:

key:value 
# comment
      
      A dictionary is returned containing key,value pairs
      as strings. lines starting with # are ignored, so are 
      usable as comments. The benefit is that site configuration 
      variables can be installed using editable whatever.cfg files to 
      minimise installers having to edit source files.

      if cfg_directory provided as None or False the file
      will be opened in current directory, otherwise it
      will be opened in the cfgdir based on the parameter provided.

      if data_directory is provided as other than None, False, "", 0 etc,
      any value for key: data_location is overridden by this parameter.
  '''
  import os.path
  if not cfgdir:
    fh=open(filename) # open configuration file
  else:
    fh=open(os.path.join(cfgdir,filename)) # open configuration file
  vars={}
  lines=fh.readlines()
  fh.close()
  for line in lines:
    if line[0] == '#' or line[0] == ' ' or line[0] == '\t' or line[0] == '\n':
      continue # skip comments or empty lines
    name,value=line.split(':',1)
    vars[name]=stripwhite(value)
  if datadir:
    vars['data_location']=datadir
  if swdir:
    vars['sw_directory']=swdir
  fh.close()
  return vars

def log(record,ldir=data_directory,lfile='nextlist.log'):
  logfile=os.path.join(ldir,lfile)
  fh=open(logfile,'a')
  import time
  asctime=time.asctime()
  record=asctime+' '+record+'\n'
  fh.write(record)

def add_header(outm,name,value):
  assert type(name) == type("string")
  assert type(value) == type("string")
  outm[name] = strip_cr_lf(value)

def do_inserts(s,Vars):
  ''' less exception prone %s format insertions in string '''
  for var in Vars:
      if '%s' in s and type(var) == type('string'):
          parts=s.split('%s',maxsplit=1)
          s=parts[0]+var+parts[1]
  return s

def add_footer(outm,text_footer,multipart=False,payload='',Vars=[]):
  import email.mime
  import email.mime.text as mime
  text_footer=do_inserts(text_footer,Vars) # text_footer contains %s for inserts
  #if multipart:
  #  text_footer=payload+'\n\n'+text_footer
  #  footer=mime.MIMEText(text_footer)
  #  outm.add_attachment(footer)
  #else:
  body = payload+'\n\n'+text_footer
  outm.set_content(body)

if __name__ == "__main__":
    # put unit test code here
    pass
