#!/usr/bin/env python
# export_emails.py
# script to extract email addresses from members table for list
# management purposes. These go into the exports directory

import sys
import os
import os.path
import rmutils
import urllib.parse
home_dir=rmutils.data_directory
web_dir=rmutils.web_directory
email_dir=rmutils.email_directory
sys.path.append(web_dir)
import cgiutils
import tablcgi
import address_textio

def main(argv):
  ''' argv is a list including listname and domain '''
  if len(argv) != 2 :
      print("list_emails: incorrect call need listname")
      return
  listname=argv[1]
  # configuration variables
  # cfgf=os.path.join(home_dir,listname,"list.cfg")
  membertab=rmutils.get_list(home_dir,listname) # member address table
  emails=membertab.keys()
  expdir=os.path.join(email_dir,'exports')
  if not os.path.isdir(expdir):
      # create directory for exports 
      os.mkdir(expdir)
      print('Created folder: '+expdir)
  fnum=1
  while True: # ensure newer file for list doesn't overwrite older one
    exportpath=os.path.join(expdir,listname+str(fnum)+'_addr.txt')
    if not os.path.isfile(exportpath):
      break
    fnum+=1
  ef=open(exportpath,"w")
  for email in emails:
    ef.write(email+'\n')
  ef.close()
  print('Exported addresses to file: '+exportpath)

if __name__ == "__main__":
    argv=sys.argv
    main(argv)

